/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view;

import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsState;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsUtil;
import edu.colorado.phet.lasers.LasersResources;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class MonitorPanel
extends ApparatusPanel {
    private static Font axisLabelFont;
    private Point2D strLoc = new Point2D.Double();
    private AffineTransform atx = new AffineTransform();
    protected int numGroundLevel;
    protected int numMiddleLevel;
    protected int numHighLevel;
    private String yAxisLabel = LasersResources.getString("MonitorPanel.YAxislabel");

    protected MonitorPanel() {
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        GraphicsState graphicsState = new GraphicsState(graphics2D);
        super.paintComponent(graphics);
        graphics2D.setFont(axisLabelFont);
        graphics2D.setColor(Color.black);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Point2D.Double double_ = new Point2D.Double(fontMetrics.getHeight() + 4, 10.0);
        Point2D.Double double_2 = new Point2D.Double(fontMetrics.getHeight() + 4, this.getBounds().getHeight() - 10.0);
        Arrow arrow = new Arrow(double_2, double_, 10.0, 10.0, 2.0);
        graphics2D.fill(arrow.getShape());
        this.strLoc.setLocation(fontMetrics.getHeight(), this.getBounds().getHeight() - 10.0);
        AffineTransform affineTransform = MonitorPanel.rotateInPlace(this.atx, -1.5707963267948966, this.strLoc.getX(), this.strLoc.getY());
        graphics2D.transform(affineTransform);
        GraphicsUtil.setAntiAliasingOn(graphics2D);
        graphics2D.drawString(this.yAxisLabel, (int)this.strLoc.getX(), (int)this.strLoc.getY());
        graphicsState.restoreGraphics();
    }

    private static AffineTransform rotateInPlace(AffineTransform affineTransform, double d, double d2, double d3) {
        affineTransform.setToIdentity();
        affineTransform.translate(d2, d3);
        affineTransform.rotate(d);
        affineTransform.translate(-d2, -d3);
        return affineTransform;
    }

    static {
        String string = "SansSerif";
        int n = 1;
        int n2 = 12;
        axisLabelFont = new Font(string, n, n2);
    }
}

